/*******************************************************************************
* therapist.py: 
*   a cheezy little Eliza knock-off by Joe Strout <joe@strout.net>
*   with some updates by Jeff Epler <jepler@inetnebr.com>
*
* Eliza.py:
*   hacked into a module and updated by Jez Higgins <jez@jezuk.co.uk>
*
* C language version(countercounseling) by Naoki Maeda <maedanaoki@z.moggy.jp>
*
* Oniguguma Ver5.9.1\r\nCopyright(C) 2007 K.Kosako
********************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "stdafx.h"
#include "countercounseling.h"
#include "oniguruma.h"
#include <windows.h>
#include <time.h>

typedef struct _patmanualdic PATMANUALDIC;
extern PATMANUALDIC *patmanual_first;
extern PATMANUALDIC *patmanual_last;
extern HWND hDlg;

int respond(char *response, UChar* str)
{	
	PATMANUALDIC *patmanual_temp;
	int r;
	unsigned char *start, *range, *end;
	OnigRegion *region;
	int num;


	srand(clock());
	patmanual_temp = patmanual_first;
	region = onig_region_new();
	for  (patmanual_temp = patmanual_first; patmanual_temp != NULL; patmanual_temp = patmanual_temp->next,onig_region_clear(region))
	{

		end   = str + strlen((char* )str);
		start = str;
		range = end;

		r = onig_search((patmanual_temp->reg), str, end, start, range, region, ONIG_OPTION_NONE);

		if (r >= 0)
		{
			num = rand() % ((patmanual_temp->size));
			if (region->beg[1] < 0)
				;
			else
				strcpy_s( str,SIZE_STR-2,str+region->beg[1]);
			strcpy_s( response, RESPONSE_SIZE-2, patmanual_temp->value[num]);
			break;
		}
		else if (r == ONIG_MISMATCH)
		{
			continue;
		}
		else
		{
			return -1;
		}
	}
	onig_region_free(region, 1);
	return 1;
}