/*******************************************************************************
* therapist.py: 
*   a cheezy little Eliza knock-off by Joe Strout <joe@strout.net>
*   with some updates by Jeff Epler <jepler@inetnebr.com>
*
* Eliza.py:
*   hacked into a module and updated by Jez Higgins <jez@jezuk.co.uk>
*
* C language version(countercounseling) by Naoki Maeda <maedanaoki@z.moggy.jp>
*
* Oniguguma Ver5.9.1\r\nCopyright(C) 2007 K.Kosako
********************************************************************************/
#include "stdafx.h"
#include "countercounseling.h"
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

typedef struct _reflectiondic REFLECTIONDIC;
extern REFLECTIONDIC *reflectiondic_first;
extern REFLECTIONDIC *reflectiondic_last;
extern HWND hDlg;
extern HINSTANCE hInst;
int add_reflectiondic (void);
int add_reflectionkey (char *key);
int add_reflectionvalue (char *value);

int makereflectiondic(void)
{
	int num = 0;
	FILE *fp;
	char *ptr;
	char line[267] = "\0\0";
	char *nexttoken;

	
	if (0 != fopen_s(&fp, "reflections", "rb"))
	{
		MessageBox(hDlg,"file error","error",0);
		return 1;
	}

	fgets (line, 255, fp);
	if (strncmp (line, "START MANUAL", 12) != 0)
		return -1;
	while (1)
	{
		fgets (line, 255, fp);
		fgets (line, 255, fp);
		if (strncmp (line, "END MANUAL", 10) == 0)
			return 1;

		nexttoken = NULL;
		ptr = strtok_s (line, ":\r\n", &nexttoken);
		if (ptr == NULL)
			return -1;
		if (add_reflectiondic() != 1)
		{
			return -1;
		}
		if (add_reflectionkey(ptr) != 1)
		{
			return -1;
		}
		ptr = strtok_s (NULL, "\r\n", &nexttoken);
		if (ptr == NULL)
			return -1;
		if (add_reflectionvalue(ptr) !=1)
			return -1;
	}
}


int add_reflectiondic (void)
{
	REFLECTIONDIC *newdic;
	char ids_memoryerror[48] = "\0\0";

	LoadString(hInst,IDS_MEMORYERROR,ids_memoryerror,32);

	if ((REFLECTIONDIC *) NULL == (newdic = (REFLECTIONDIC *) malloc (sizeof (REFLECTIONDIC))))
	{
		MessageBox (hDlg, ids_memoryerror, "error",0);
		exit (0);
	}
	memset(newdic,0,sizeof(REFLECTIONDIC));

	if ((REFLECTIONDIC *) NULL == reflectiondic_first)
	{
		reflectiondic_first = newdic;
		reflectiondic_last = newdic;
		reflectiondic_first->next = NULL;
		reflectiondic_last->next = NULL;
	}
	else
	{
		reflectiondic_last->next = newdic;
		reflectiondic_last = newdic;
		reflectiondic_last->next = NULL;
	}
	return 1;
}

int add_reflectionkey (char *key)
{
	char *newkey;
	char ids_memoryerror[48] = "\0\0";

	LoadString(hInst,IDS_MEMORYERROR,ids_memoryerror,32);
	if ((char *) NULL == (newkey = (char *) malloc (strlen(key)+4)))
	{
		MessageBox (hDlg, ids_memoryerror, "error",
			0);
		exit (0);
	}
	memset(newkey,0,sizeof(strlen(key)+4));
	strcpy_s(newkey, strlen(key)+2, key);
	reflectiondic_last->key = newkey;
	return 1;
}
int add_reflectionvalue (char *value)
{
	char *newvalue;
	char ids_memoryerror[48] = "\0\0";

	LoadString(hInst,IDS_MEMORYERROR,ids_memoryerror,32);
	if ((char *) NULL == (newvalue = (char *) malloc (strlen(value)+4)))
	{
		MessageBox (hDlg, ids_memoryerror, "error",0);
		exit (0);
	}
	memset(newvalue,0,sizeof(strlen(value)+4));
	strcpy_s(newvalue, strlen(value)+2, value);
	reflectiondic_last->value = newvalue;
	return 1;
}
