/*******************************************************************************
* therapist.py: 
*   a cheezy little Eliza knock-off by Joe Strout <joe@strout.net>
*   with some updates by Jeff Epler <jepler@inetnebr.com>
*
* Eliza.py:
*   hacked into a module and updated by Jez Higgins <jez@jezuk.co.uk>
*
* C language version(countercounseling) by Naoki Maeda <maedanaoki@z.moggy.jp>
*
* Oniguguma Ver5.9.1\r\nCopyright(C) 2007 K.Kosako
********************************************************************************/
#include "stdafx.h"
#include "countercounseling.h"
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "oniguruma.h"

typedef struct _patmanualdic PATMANUALDIC;
extern PATMANUALDIC *patmanual_first;
extern PATMANUALDIC *patmanual_last;
extern HWND hDlg;
extern HINSTANCE hInst;
int add_patmanualdic (void);
int add_patmanualkey (char *key);
int add_patmanualvalue (char *value, int num);
int add_patmanualsize (int num);

int makepatmanualdic(void)
{
	int num = 0;
	FILE *fp;
	char *ptr;
	char line[267] = "\0\0";
	char *nexttoken;

	if (0 != fopen_s(&fp, "patmanual", "rb"))
	{
		MessageBox(hDlg,"file error","error",0);
		return 1;
	}

	fgets (line, 255, fp);
	if (strncmp (line, "START MANUAL", 12) != 0)
		return -1;
	while (1)
	{
		fgets (line, 255, fp);
		fgets (line, 255, fp);
		if (strncmp (line, "END MANUAL", 10) == 0)
			return 1;

		nexttoken = NULL;
		ptr = strtok_s (line, "\r\n", &nexttoken);
		if (ptr == NULL)
			return -1;
		if (add_patmanualdic() != 1)
		{
			return -1;
		}

		if (add_patmanualkey(ptr) != 1)
		{
			return -1;
		}
		fgets (line, 255, fp);

		for (num = 0; strncmp(line, "NULL,",5) != 0; ++num,fgets (line, 255, fp))
		{
			nexttoken = NULL;
			ptr = strtok_s (line, "\r\n", &nexttoken);
			if (ptr == NULL)
				return -1;
			if (add_patmanualvalue(ptr, num) != 1)
				return -1;

		}
		if (add_patmanualsize(num) != 1)
			return -1;
	}
}


int add_patmanualdic (void)
{
	PATMANUALDIC *newdic;
	char ids_memoryerror[48] = "\0\0";

	LoadString(hInst,IDS_MEMORYERROR,ids_memoryerror,32);
	if ((PATMANUALDIC *) NULL == (newdic = (PATMANUALDIC *) malloc (sizeof (PATMANUALDIC))))
	{
		MessageBox (hDlg, ids_memoryerror, "error",0);
		exit (0);
	}
	memset(newdic,0,sizeof(PATMANUALDIC));

	if ((PATMANUALDIC *) NULL == patmanual_first)
	{
		patmanual_first = newdic;
		patmanual_last = newdic;
		patmanual_first->next = NULL;
		patmanual_last->next = NULL;
	}
	else
	{
		patmanual_last->next = newdic;
		patmanual_last = newdic;
		patmanual_last->next = NULL;
	}
	return 1;
}

int add_patmanualkey (char *key)
{  
	int r;
	OnigErrorInfo einfo;
	UChar* pattern = (UChar* )(key);
	regex_t* newreg;
	char ids_memoryerror[48] = "\0\0";

	LoadString(hInst,IDS_MEMORYERROR,ids_memoryerror,32);

	if ((regex_t *) NULL == (newreg = (regex_t *) malloc (sizeof(regex_t))))
	{
		MessageBox (hDlg, ids_memoryerror, "error",0);
		exit (0);
	}
	memset(newreg,0,sizeof(regex_t));
	r = onig_new(&newreg, pattern, pattern + strlen((char* )pattern),ONIG_OPTION_IGNORECASE, ONIG_ENCODING_ASCII, ONIG_SYNTAX_DEFAULT, &einfo);
	if (r != ONIG_NORMAL)
		return -1;
	patmanual_last->reg = newreg;
	return 1;


}
int add_patmanualvalue (char *value, int num)
{
	char *newvalue;
	char ids_memoryerror[48] = "\0\0";

	LoadString(hInst,IDS_MEMORYERROR,ids_memoryerror,32);
	if (num > 20)
		return -1;
	if ((char *) NULL == (newvalue = (char *) malloc (strlen(value)+4)))
	{
		MessageBox (hDlg, ids_memoryerror, "error", 0);
		exit (0);
	}
	memset(newvalue,0,sizeof(strlen(value)+4));
	strcpy_s(newvalue, strlen(value)+2, value);
	patmanual_last->value[num] = newvalue;
	return 1;
}
int add_patmanualsize (int num)
{
	patmanual_last->size = num;
	return 1;
}