/*******************************************************************************
* therapist.py: 
*   a cheezy little Eliza knock-off by Joe Strout <joe@strout.net>
*   with some updates by Jeff Epler <jepler@inetnebr.com>
*
* Eliza.py:
*   hacked into a module and updated by Jez Higgins <jez@jezuk.co.uk>
*
* C language version(countercounseling) by Naoki Maeda <maedanaoki@z.moggy.jp>
*
* Oniguguma Ver5.9.1\r\nCopyright(C) 2007 K.Kosako
********************************************************************************/
#include "oniguruma.h"
#include "stdafx.h"
#include "countercounseling.h"
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>


#define MAX_LOADSTRING 100
typedef struct _reflectiondic REFLECTIONDIC;
REFLECTIONDIC *reflectiondic_first;
REFLECTIONDIC *reflectiondic_last;
typedef struct _patmanualdic PATMANUALDIC;
PATMANUALDIC *patmanual_first;
PATMANUALDIC *patmanual_last;


HINSTANCE hInst;
TCHAR szTitle[MAX_LOADSTRING];
TCHAR szWindowClass[MAX_LOADSTRING];


HWND hDlg;
char szClassName[] = "countercounseling-jp";

int outputdebug (char *data, char *data2);
int makepatmanualdic(void);
int makereflectiondic(void);
int respond (char *response, char* str2);
int translate (char *str);
int OutPutData (char *command, char *resp1, char *resp2, char *resp3);
int free_all (void);

ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
BOOL CALLBACK	CounterCounselingWndProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK	About(HWND, UINT, WPARAM, LPARAM);


int APIENTRY WinMain(HINSTANCE hInstance,
					 HINSTANCE hPrevInstance,
					 LPTSTR    lpCmdLine,
					 int       nCmdShow)
{
	MSG msg;
	hInst = hInstance;
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!hDlg || !IsDialogMessage (hDlg, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HICON hIcon;
	char ids_explanation[350] = "\0\0";
	char ids_byword[48] = "\0\0";
	hInst = hInstance;

	hDlg = CreateDialog(hInst, MAKEINTRESOURCE(IDD_COUNTERCOUNSELING), NULL, (DLGPROC)CounterCounselingWndProc);
	if (!hDlg)
	{
		return FALSE;
	}
	ShowWindow(hDlg, SW_NORMAL);
	UpdateWindow(hDlg);

	makepatmanualdic();
	makereflectiondic();
	LoadString(hInst,IDS_EXPLANATION,ids_explanation,350);
	LoadString(hInst,IDS_BYWORD,ids_byword,48);
	OutPutData("",ids_explanation,"","");
	OutPutData(">",ids_byword,"","");
	SetFocus(GetDlgItem(hDlg, IDC_EDIT_USER));
	SendDlgItemMessage(hDlg, IDC_EDIT_USER, EM_SETSEL, 0, -1);

	hIcon = (HICON) LoadImage (hInst, MAKEINTRESOURCE (IDI_COUNTERCOUNSELING), IMAGE_ICON, 48, 48, 0);
	SendMessage (hDlg, WM_SETICON, ICON_BIG, (LPARAM) hIcon);
	return TRUE;
}

BOOL CALLBACK CounterCounselingWndProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId;
	int pos;
	char *ptr;
	char str[SIZE_STR] = "\0\0";
	char response[RESPONSE_SIZE] = "\0\0";

	switch (message)
	{
	case WM_INITDIALOG:
		{	
			return (INT_PTR)TRUE;
		}

	case WM_CLOSE:
		{
			free_all();
			PostQuitMessage (0);
			break;
		}

	case WM_COMMAND:
		wmId    = LOWORD(wParam);

		switch (wmId)
		{
		case IDM_ABOUTBOX_HELP:
			{
				DialogBox( hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hDlg, (DLGPROC)About);
				break;
			}
		case IDM_ABOUTBOX_EXIT:
			{
				SendMessage(hDlg,WM_CLOSE,0,0);
				break;
			}
		case IDC_BUTTON_SUBMIT:
			{
				memset(str,0,SIZE_STR);
				SendMessage (GetDlgItem (hDlg, IDC_EDIT_USER), WM_GETTEXT, 250, (LPARAM) str);
				pos = (int)SendMessage (GetDlgItem (hDlg, IDC_EDIT_USER), WM_GETTEXTLENGTH, 0, 0);
				SendMessage (GetDlgItem (hDlg, IDC_EDIT_USER), EM_SETSEL, 0, pos);
				SendMessage (GetDlgItem (hDlg, IDC_EDIT_USER), EM_REPLACESEL, FALSE,(LPARAM) "\0\0");
				if (strlen(str) == 0)
					strcpy_s(str,SIZE_STR,"...");

				OutPutData(">","","",str);

				if (respond(response, str) == -1)
				{
					MessageBox(hDlg,"","error",0);
					break;
				}
				ptr = strchr(response,'%%');
				if (ptr == NULL)
				{
					str[0] = '\0';
					ptr = &str[0];
				}

				else
				{
					translate (str);
					*ptr = '\0';
					ptr = ptr + 2;
				}
				strcat_s(str,SIZE_STR-2,ptr);
				if ( ( str[strlen(str)-2] == '?' ) && (str[strlen(str)-1] == '.') ) 
				{
					str[strlen(str)-2] = '.';
				    str[strlen(str)-1] = '\0';
				}
				if ( ( str[strlen(str)-2] == '?' ) && (str[strlen(str)-1] == '?') ) 
				{
					str[strlen(str)-2] = '?';
				    str[strlen(str)-1] = '\0';
				}
				if ( ( str[strlen(str)-2] == '.' ) && (str[strlen(str)-1] == '?') ) 
				{
					str[strlen(str)-2] = '?';
				    str[strlen(str)-1] = '\0';
				}
				OutPutData(">",response,str,"");
				break;
			}

		}
	}
	return (INT_PTR)FALSE;
}


BOOL CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDC_BUTTON_CLOSE_ABOUT)
		{ 
			EndDialog(hDlg, IDOK);
		}
		return (INT_PTR)FALSE;
	}
	return (INT_PTR)FALSE;
}